# -*- coding: utf-8 -*-
import time
import csv
import subprocess
import datetime
import sys
import os
import ConfigParser
import calendar
import zipfile
import glob

conf = ConfigParser.SafeConfigParser()
conf.read("./sr.conf")

try:
	from PIL import Image
except ImportError:
	print "Error! PIL is not installed!"
	time.sleep(1000)
	exit()

try:
	import cv
except ImportError:
	if conf.get("analyze", "get_pixel") == "cv":
		print "Error! OpenCV is not installed!"
	
try:
	import numpy
except ImportError:
	print "Error! numpy is not installed!"
	time.sleep(1000)
	exit()
	
def server():
	try:
		subprocess.call(["python", "-m", "CGIHTTPServer"])
	except socket.error, e:
		pass
	return()
	
def make_zip(filepath, filename):#Zip形式で圧縮する 単一のCSVファイル用
	os.chdir("./CSV")
	zipFile = zipfile.ZipFile(filename + ".zip","w",zipfile.ZIP_DEFLATED)
	zipFile.write(filename)
	zipFile.close()
	os.chdir("..")
	
def make_data_zip():
	pass
	
def rec(filename):#録音
	subprocess.Popen(['sox', "-d", '-c', '1', "./ogg/" + filename, 'trim', '0', '300'])#, "-V[1]"])
	#output = subprocess.call(['ping', 'google.com'], shell=1)
	print "Recording start"
	return()

def freq_rec(header):
	now_minute = int(datetime.datetime.now().strftime("%M"))
	now_hour = int(datetime.datetime.now().strftime("%H"))
	now_month = int(datetime.datetime.now().strftime("%m"))
	now_day = int(datetime.datetime.now().strftime("%d"))
	now_year = int(datetime.datetime.now().strftime("%Y"))

	while 1==1:
		if int(datetime.datetime.now().strftime("%M")) % 5 == 0:
			start_year = str(datetime.datetime.now().strftime("%Y"))[2:]
			start_month = str(datetime.datetime.now().strftime("%m"))[:]
			if start_month < 10:
				start_month = "0" + str(datetime.datetime.now().strftime("%m"))[:]
			start_day = str(datetime.datetime.now().strftime("%d"))[:]
			if start_day < 10:
				start_day = "0" + str(datetime.datetime.now().strftime("%d"))[:]
			start_hour = str(datetime.datetime.now().strftime("%H"))[:]
			if start_hour < 10:
				start_hour = "0" + str(datetime.datetime.now().strftime("%H"))[:]
			start_minute = str(datetime.datetime.now().strftime("%M"))[:]
			if datetime.datetime.now().strftime("%M") < 9:
				start_minute = "0" + str(datetime.datetime.now().strftime("%M"))[:]
			filename = header + str(start_year)[:] + str(start_month)[:] + str(start_day)[:] + str(start_hour)[:] + str(start_minute)[:]
			print "Filename is " + filename + ".ogg"
			#time.sleep(wait_time*0.01)
			time.sleep(0.01)
			rec(filename + ".ogg")
			time.sleep(100)
		time.sleep(0.001)
	return
	

def zip_write_dir(src_dir, zip_name):
    zf = zipfile.ZipFile(zip_name, 'w', zipfile.ZIP_DEFLATED)
    for root,dirs,files in os.walk(src_dir):
        for _file in files:
            filename = os.path.join(root,_file)
            arcname = filename
            zf.write(filename, arcname)
    zf.close()
	
def unzip(strength_list, filename, header):
	with zipfile.ZipFile('./CSV/' + filename + '.csv.zip', 'r') as post:
		#print post.read(filename)
		unziped = post.read(filename + ".csv").split('\r\n')
		for unziped_line in unziped:
			#print unziped_line
			unziped_line = unziped_line[:]
			#print unziped_line
			#print unziped_line.split(',')
			xlist = []
			for strength in unziped_line.split(','):
				#print strength
				if strength.isdigit() == True:
					xlist.append(int(strength))
				#print strength
			strength_list.append(xlist)
			#print 1
			#strength_list.append(int(row[0]))
			
		#exdfile = file("a.csv", wb)
		#uzf.write(zf.read(f))
		#print len(strength_list[20])
		return strength_list

def get_rgb(pos):#これは使わない
	global img
	img = img.convert("RGB")
	rgb = img.getpixel(pos)
	return(rgb)

def open_image(filename):#これはつかわない、つかえない
	#global img
	img = Image.open(filename)
	return
	
def get_strength(pos):#これを使うととても遅いので使わない
	rgb = get_rgb(pos)
	if rgb[0] == rgb[1] and rgb[1] == rgb[2]:
		strength = rgb[0]
	else:
		print "Error this is color image"
	return(strength)

def make_list(img, get_pixel):#強度のリストを作る
	strength_list = []
	if get_pixel != "cv":
		img = img.convert("RGB")
	print "start making list"
	for cntx in range(2394):   #58-2451 #2393
		#print "   " + str(cntx)
		listy = []
		for cnty in range(70):    #184-115
			#print cnty
			pos = (cntx + 58,cnty + 115)#115
			#print pos
			if get_pixel == "cv":
				rgb = cv.Get2D(img, pos[1], pos[0])
			else:
				rgb = img.getpixel(pos)
			if rgb[0] == rgb[1] and rgb[1] == rgb[2]:
				strength = rgb[0]
			else:
				print "Error this is color image"
			listy.append(strength)
			#print listy
			time.sleep(0.0001)
		#print listy
		strength_list.append(listy)
	print "finished making list "
	return(strength_list)
	
def write_csv(strength_list, filetime, compress, header):#その名の通り,1がCSVのみ、2がZIPのみ、それ以外が両方
	writecsv = csv.writer(file("./CSV/" + filetime + ".csv", 'w'), lineterminator='\n') 
	#len_list = len(strength_list)
	for cnt in range(2394):
		writecsv.writerow(strength_list[cnt][:])
	if compress != 1:
		make_zip("./CSV/", filetime + ".csv")
		"""
		if compress == 2:
			while True:
				time.sleep(0.1)
				print "./CSV/" + filetime + "csv.zip"
				if os.path.exists("./CSV/" + filetime + "csv.zip") == 1:
					print "./CSV/" + filetime + "csv.zip"
					try:
						os.remove("./CSV/" + filetime + ".csv")
					except:
						print "Error!"
						"""
	return()
	
def read_csv(strength_list, filetime, header):#その名の通り
	#readcsv = csv.reader(file(filetime + ".csv", 'r'), lineterminator='\n') 
	"""
	for cnt in range(2394):
		#readcsv.readrow(strength_list[cnt][:])
		strength_list.append(readcsv.readlines())
		"""
	for row in csv.reader(open("./CSV/" + filetime + ".csv", 'rb')):
		#for cnt in row:	
		strength_list.append(row)
	return(strength_list)
		
def how_long(filename):#OGGファイルの長さを調べる
	file_info = (-1,-1,-1) 
	if os.path.exists(filename) == True: 
		output = subprocess.check_output(["sox", "--info", "-d", filename])
		#print output
		minute = output[4]
		ten_second = output[6]
		second = output[7]
		file_info = (minute , ten_second, second)
	return(file_info)		

def spec(filename, mono_color):#スペクトラム描画
	#output = subprocess.call(['sox', filename + ".ogg", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-o", filename + ".png" ])
	wq = ''
	oggfilename = wq + "./ogg/" + filename + ".ogg" + wq
	pngfilename = wq + "./PNG/" + filename + ".png" + wq
	monofilename = wq + "./monoPNG/" + filename + ".png" + wq
	if mono_color != True:
		output = subprocess.Popen(['sox', oggfilename[:], "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-o", pngfilename[:] ])
	print filename +".png" + " was made"
	subprocess.Popen(['sox', "./ogg/" + filename + ".ogg", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100"])
	output = subprocess.Popen(['sox', oggfilename[:], "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-m", "-o", monofilename[:] ])
	return(output)
		
def get_strength_average(strength_list,cntx):
	strength_average = 0
	strength_sum = 0
	for average_cnt in range(70): 
		strength_sum = strength_sum + int(strength_list[cntx][average_cnt])
	strength_average = strength_sum / 70
	#print "                    " + str(strength_sum / 40)
	return(strength_average)
	
def around_ave(x,y,strength_list):#リストから出ないように注意。
	around_sum = 0
	for cntx in range(3):
		around_sum += strength_list[x + cntx - 1][y - 1]
	
	
def analyze(strength_list, echo_threshold, unite_echo_threshold, compared_with_pixels):#エコーカウント
	echo_list = []
	echo_time = []
	freq_list = []
	long_list = []
	all_list = []
	freq_median = 0
	long_start = 0
	whole_strength_average = 0
	all_stremgth_median = 0
	ave_sum = 0
	for cnt in range(2394):
		ave_sum = ave_sum + get_strength_average(strength_list,cnt)
	whole_strength_average = ave_sum / 2394
	for cnt in range(2394):
		for cntx in range(70):
			all_list.append(int(strength_list[cnt][cntx]))
	all_strength_median = int(numpy.median(all_list))
	#print all_strength_median
	#print whole_strength_average
	#print echo_threshold
	#time.sleep(1000)
	#exit()
	#print "analyze start"
	strong_list = []
	for cntx in range(2394):
		echo_freq = 0
		#print cntx + 58
		echo1 = False
		echo2 = False
		echo3 = False
		echo = False
		#echo_list.append([echo, echo_freq])
		#echo_list.append([])
		#echo_list[cntx].append([0])
		#echo_list[cntx][].append([0])
		for cnty in range(70):
			#print cnty
			#中央値を比較対象にする
			if compared_with_pixels == "median" and int(strength_list[cntx][cnty]) > all_strength_median + echo_threshold:
				#strong_list.append(cntx,cnty)
				if int(strength_list[cntx][cnty]) > get_strength_average(strength_list,cntx) + echo_threshold:
					#print int(strength_list[cntx][cnty]) - int(all_strength_median + echo_threshold)
					"""
					print all_strength_median + echo_threshold - int(strength_list[cntx][cnty])
					print int(strength_list[cntx][cnty])
					print all_strength_median + echo_threshold
					"""
					#time.sleep(10)
					strength_sum = 0
					#その時刻の強さの平均よりエコーが大きい
					#print "echo!"
					echo1 = True
					echo = 1
					if echo_freq != 0:
						if int(strength_list[cntx][echo_freq]) < int(strength_list[cntx][cnty]):
							echo_freq = cnty
								#print echo_freq
								#前のエコーより今のエコーが大きかったらecho_freqを書き換える
								#echo_list[cntx][1] = cnty#echo_listにy座標を加える
					else:
						echo_freq = cnty
							#print len(echo_list[cntx])
							#echo_list[cntx][1] = cnty#echo_listにy座標を加える
			
			
			#平均を比較対象にする
			elif compared_with_pixels == "average" and int(strength_list[cntx][cnty]) > get_strength_average(strength_list,cntx) + echo_threshold:
				strength_sum = 0
				if int(strength_list[cntx][cnty]) > whole_strength_average + echo_threshold:
					#その時刻の強さの平均よりエコーが大きい
					#print "echo!"
					echo1 = True
					echo = 1
					if echo_freq != 0:
						if int(strength_list[cntx][echo_freq]) < int(strength_list[cntx][cnty]):
							echo_freq = cnty
							#print echo_freq
							#前のエコーより今のエコーが大きかったらecho_freqを書き換える
							#echo_list[cntx][1] = cnty#echo_listにy座標を加える
					else:
						echo_freq = cnty
						#print len(echo_list[cntx])
						#echo_list[cntx][1] = cnty#echo_listにy座標を加える
						
			
			"""
			else:
				if cntx > 2:
					before_sum2 = int(strength_list[cntx][cnty]) + int(strength_list[cntx - 1][cnty])
					if before_sum2 / 2 > int(strength_list[cntx -2][cnty]) + 40:
						#if int(strength_list[cntx - 1][cnty]) + 40 < int(strength_list[cntx][cnty]):
						#1つ前、2つ前の平均と比べる
						average_cnt = 0
						
						for average_cnt in range(15,55):
							strength_sum = strength_sum + int(strength_list[cntx][average_cnt])
						strength_average = strength_sum / 40
						print "              " + str(strength_sum / 40)
						
						#print str(strength_list[cntx][cnty])+ "   " + str(get_strength_average(strength_list,cntx))
						if int(strength_list[cntx][cnty]) > get_strength_average(strength_list,cntx) + 40:
							#その時刻の強さの平均よりエコーが大きい
							print "echo2!"
							echo = 2
							#echo_list[cntx][0] = cntx#echo_listにx座標を加える
							if echo_freq != 0:
								if int(strength_list[cntx][echo_freq]) + 50 < int(strength_list[cntx][cnty]):
									echo_freq = cnty
									#前のエコーより今のエコーが大きかったらecho_freqを書き換える
									echo2 = True
									
									#echo_list[cntx][1] = cnty#echo_listにy座標を加える
							else:
								echo_freq = cnty
								#echo_list[cntx][1] = cnty#echo_listにy座標を加える
								"""
			"""					
		if len(echo_time) > 3:
			if echo_list[cntx - 1][1] == 500:#一つ前のXもエコーであるとき
				if echo_list[cntx - 2][1] == 500:
					print 4444444444444444444444444444
					if abs(int(strength_list[cntx][cnty]) - int(strength_list[cntx - 1][cnty])) < 100:
						echo3 =True
						echo = 3
						print 33333333333333333333333333333333333333333
						#if echo1 == True or echo2 == True:
							"""
					
		if echo == 1 or echo == 2:#echo_timeへの記録
			if len(echo_list) != 0:
				if echo_list[len(echo_list) - 1][2] != cntx - 1 + 58:
					echo_time.append(cntx + 58)
					echo_list.append([echo, echo_freq + 115, cntx + 58])
				else:
					echo = 3
					echo_list.append([echo, echo_freq + 115, cntx + 58])
			else:
				echo_time.append(cntx + 58)
				echo_list.append([echo, echo_freq + 115, cntx + 58])
				#print 22222222222222222222222222222222
		
		"""		
		if echo_freq == 0:
			freq_list.append(echo_freq + 500)
			echo_list.append([echo, echo_freq + 500])
		else:
			freq_list.append(echo_freq + 115)
			echo_list.append([echo, echo_freq + 115])
 		"""
 		#echo_list.append([echo, echo_freq])
 		
			#if if1 == True:
			#	for average_cnt in range(80,221):
			#		strength_sum = strength_sum + strength_list[cntx][average_cnt]
			#	strength_average = strength_sum / 40
			#	if strength_list[cntx][cnty] + 40 > strength_average:
			#		if2 = True
					#その時刻の強さの平均よりエコーが大きい
			#	else:
			#		if2 = False
			
	#エコーじゃないものを排除する（できるかなぁ）
	long_list = []
	for cnt in range(len(echo_list)):
		if echo_list[cnt][0] == 3 and echo_list[cnt -1][0] != 3:
			pass
			
	if len(echo_list) > 0:
		for cnt in range(len(echo_list)):#周波数のリストをつくる
			freq_list.append(echo_list[cnt][1])
		freq_median = numpy.median(freq_list)#周波数の中央値を取る
	
		for cnt in range(len(echo_list)):
			if abs(echo_list[cnt][1] - freq_median) > 5:#周波数の中央値よりかなり離れていたら
				echo_list[cnt][0] = 4#エコーとしてみなさない
			time.sleep(0.00001)
		
		freq_median_list = []
		for cnt in range(0,2393):#X軸でいろいろ見る
			#print cnt
			#print int(freq_median) - 58
			freq_median_list.append(int(strength_list[cnt][int(freq_median) - 115]))
			time.sleep(0.00001)
		freq_median_strength = numpy.median(freq_median_list)
		for cnt in range(0,len(echo_list) - 1):
			#print cnt
			#print echo_list[cnt][2]
			#print echo_list[cnt][1]
			if int(strength_list[echo_list[cnt][2] - 58][echo_list[cnt][1] - 115]) + echo_threshold < freq_median_strength:
				echo_list[cnt][0] = 4
			time.sleep(0.00001)
	
		#分かれて検知されてしまったエコーをつなげる
	for cntecho in range(0,len(echo_list)):
		#if echo_list[cntecho][0] == 3:
		#	continue
		if cntecho == len(echo_list) - 1:
			break

		whilecnt = 0
		while 1==1:#近いエコーをつなげる
			if whilecnt == 0:
				whilecnt += 1
				continue
			if whilecnt > 10:
				unite_echo_threshold = 15
			if cntecho + whilecnt == len(echo_list) or echo_list[cntecho + whilecnt][2] - echo_list[cntecho][2] > unite_echo_threshold:
				break
			if echo_list[cntecho + whilecnt][2] == 3:
				whilecnt += 1
				continue
			#print str(echo_list[cntecho + whilecnt][2] - echo_list[cntecho][2])
			echo_list[cntecho + 1][0] = 3
			whilecnt += 1
			time.sleep(0.00001)
		
	echo_time = []
	for cnt in range(len(echo_list)):#echo_timeを作りなおす
		if echo_list[cnt][0] == 1:
			echo_time.append(echo_list[cnt][2])
	
	print echo_time
	#print long_list
	#print freq_list
	#print echo_list
	return(echo_time)

def make_csv(todo, filetime, echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel, header):
	strength_list = []

	if todo == "a":
		"""
		if os.path.exists("./CSV/" + header + filetime + ".csv.zip") == True:
			#try:
			strength_list = unzip(strength_list, filetime, header)
			#except:
				#exit()
		"""
		if os.path.exists("./CSV/" + filetime + ".csv") == True:
			try: 
				strength_list = read_csv(strength_list, filetime, header)
			except:
				pass
		analyze_return = analyze(strength_list, echo_threshold, unite_echo_threshold, compared_with_pixels)
		writetxt = open("./echo/" + filetime + '.echo', 'w')
		writetxt.write(str(analyze_return)[1:-1])
		writetxt.close()
	elif todo == "c":
		filename = filetime + ".png"
		if get_pixel == "cv":
			img = cv.LoadImage("./monoPNG/" + filename[:])
		else:
			img = Image.open("./monoPNG/" + filename[:])
		strength_list = make_list(img, get_pixel)
		write_csv(strength_list, filetime, 2, "")
	elif todo == "ac":
		filename = filetime
		if get_pixel == "cv":
			img = cv.LoadImage("./monoPNG/" + filename[:] + ".png")
		else:
			print "./monoPNG/" + filename[:] + ".png"
			img = Image.open("./monoPNG/" + filename[:] + ".png")
		strength_list = make_list(img, get_pixel)
		write_csv(strength_list, filetime, 2, header)
		analyze_return = analyze(strength_list, echo_threshold, unite_echo_threshold, compared_with_pixels)
		writetxt = open("./echo/" + filename[:] + '.echo', 'w')
		writetxt.write(str(analyze_return)[1:-1])
		writetxt.close()

def make_rmob(year,month,header):#yearは下2桁だけ。数字で。
	month_end = calendar.monthrange(year, month)[1]
	strength_list = []
	writetxt = ""
	stryear = ""
	strmonth = 	""
	strday = ""
	strhour = ""
	strminute = ""
	stryear = str(year)
	strmonth = str(month)
	day_list = []
	echo_threshold = 0
	unite_echo_threshold = 0
	
	conf = ConfigParser.SafeConfigParser()
	conf.read("./sr.conf")
	echo_threshold = int(conf.get("analyze", "echo_threshold"))
	unite_echo_threshold = int(conf.get("analyze", "unite_echo_threshold"))
	compared_with_pixels = (conf.get("analyze", "compared_with_pixels"))
	get_pixel = conf.get("analyze", "get_pixel")
	"""
	oggfilelist = glob.glob("./ogg/" + str(year) + str(month) + "*.ogg")
	pngfilelist = glob.glob("./monoPNG/" + str(year) + str(month) + "*.png")
	echofilelist = glob.glob("./echo/" + str(year) + str(month) + "*.echo")

	for cnt in (filelist):
		print cnt[6:][:10]
		if os.path.exists("./CSV/" + header + cnt[6:][:10] + ".csv") == True:
			libhro.make_csv("a", header, cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
		elif os.path.exists("./monoPNG/" + header + cnt[6:][:10] + ".png") == True:
			libhro.make_csv("ac", header + cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
		else:
			if how_long("./ogg/" + header + cnt[6:][:10] + ".ogg")[0] == "5":
				libhro.spec(header + cnt[6:][:10], True)
				time.sleep(5)
				libhro.make_csv("ac", header + cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel)
	"""
	
	filelist = glob.glob("./*/" + header + "*.csv")#すべて処理する

	for cnt in (filelist):
		print cnt[6:][:10]
		if os.path.exists("./echo/" + cnt[6:][:10] + ".echo") == True:
			continue
		elif os.path.exists("./CSV/" + cnt[6:][:10] + ".csv") == True:#CSV
			make_csv("a", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel, header)
		elif os.path.exists("./monoPNG/" + cnt[6:][:10] + ".png") == True:#PNG
			make_csv("ac", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel, header)
		else:
			if how_long("./ogg/"+ cnt[6:][:10] + ".ogg")[0] == "5":#OGG
				spec(cnt[6:][:10], True)
				time.sleep(5)
				make_csv("ac", cnt[6:][:10], echo_threshold, unite_echo_threshold, compared_with_pixels, get_pixel, header)
			
	stryear = str(year)
	strmonth = str(month)
	if year < 10:
		stryear = "0" + str(year)
	if month < 10:
		strmonth = "0" + str(month)
	echo_list =  []
	cnt = 0
	print "monthend" + str(month_end)
	for cnt in range(1,month_end + 1):
		strday = str(cnt)
		if cnt < 10:
			strday = "0" + str(cnt)
		day_list = []
		for hour_cnt in range(0,24):
			strhour = str(hour_cnt)
			if hour_cnt < 10:
				strhour = "0" + str(hour_cnt)
			hour_echo = -1#-1はデータ無し
			for six_cnt in range(0,12):
				minite_echo  = 0
				minute_list = []
				strminute = str(int(1.0 * six_cnt / 2 * 10))
				if six_cnt == 0:
					strminute = "00"
				if six_cnt == 1:
					strminute = "05"
				filename = header + stryear + strmonth + strday + strhour + strminute
				if os.path.exists("./echo/" + filename + ".echo") == True:
					print filename + ".echo found"
					for row in csv.reader(open("./echo/" + filename + ".echo", 'rb')):
						minute_list.append(row)
				else:
					print filename + ".echo not found"
				if len(minute_list) != 0:
					hour_echo = hour_echo + len(minute_list[0])
				#print minute_list
				#print hour_echo
			#print hour_echo
			day_list.append(hour_echo)
		echo_list.append(day_list)
	#CSV書き出し
	writecsv = csv.writer(file("./monthly data/" + header + stryear + strmonth + ".csv", 'w'), lineterminator='\n') 
	for cnt in range(month_end):
		writecsv.writerow(echo_list[cnt])
	print echo_list
	
